% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.interactions.r
\name{sigInteractorsDIGGIT}
\alias{sigInteractorsDIGGIT}
\title{Filter interactions from NES (DIGGIT) scores and corresponding 
background-corrected scores.}
\usage{
sigInteractorsDIGGIT(
  corrected.scores,
  nes.scores,
  cindy,
  p.thresh = 0.05,
  cindy.only = TRUE
)
}
\arguments{
\item{corrected.scores}{A list indexed by the genomic event/gene with 
corresponding pvals and qvals for each TF}

\item{nes.scores}{Matrix with tfs as columns, rows are genomic events}

\item{cindy}{CINDy algorithm output matrix}

\item{p.thresh}{P-value threshold (default=0.05)}

\item{cindy.only}{Consider only CINDy validated interactions (default=TRUE)}
}
\value{
a list (indexed by VIPER protein) of significant genomic interactions 
and associated pvals over the background (null TF) model, and NES scores
}
\description{
Use this version in the Bayes model to rank TFs
}
\keyword{internal}
