% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.r
\name{cnvScoreStouffer}
\alias{cnvScoreStouffer}
\title{Integrate CNV scores}
\usage{
cnvScoreStouffer(
  mapping,
  diggit.interactions,
  cytoband = TRUE,
  from.p = FALSE,
  pos.nes.only = TRUE
)
}
\arguments{
\item{mapping}{a named vector of genomic locations/cytoband IDs. 
names are the gene names for each--i.e. a many to one mapping from HUGO or entrez IDs to cytoband location}

\item{diggit.interactions}{list indexed by MR/TF name in Entrez Space each points to a named vector of NES / z-scores associated with entrez IDs for each interacting event.}

\item{cytoband}{Boolean to use cytoband locations for computing final integrated score}

\item{from.p}{Boolean, set TRUE if diggit.interaction values are p-values instead of z-scores}

\item{pos.nes.only}{Boolean, only consider positive DIGGIT association scores when ranking candidate MRs (default=TRUE)}
}
\value{
A vector of z-scores, named by the Master Regulators in 'diggit.interactions'
}
\description{
Integrate CNV scores
}
