% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefisto.R
\name{plot_group_kernel}
\alias{plot_group_kernel}
\title{Heatmap plot showing the group-group correlations per factor}
\usage{
plot_group_kernel(object, factors = "all", groups = "all", ...)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object using MEFISTO.}

\item{factors}{character vector with the factors names, or numeric vector indicating the indices of the factors to use}

\item{groups}{character vector with the groups names, or numeric vector with the indices of the groups of samples to use, or "all" to use samples from all groups.}

\item{...}{additional parameters that can be passed to  \code{pheatmap}}
}
\value{
Returns a \code{ggplot,gg} object containing the heatmaps
}
\description{
Heatmap plot showing the group-group correlations inferred by the model per factor
}
\details{
The heatmap gives insight into the clustering of the patterns that factors display along the covariate in each group. 
A correlation of 1 indicates that the module captured by a factor shows identical patterns across groups, a correlation of zero that it shows distinct patterns,
a negative correlation that the patterns go in opposite directions.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "MEFISTO_model.hdf5", package = "MOFA2")
model <- load_model(file)
plot_group_kernel(model)
}
