% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefisto.R
\name{plot_data_vs_cov}
\alias{plot_data_vs_cov}
\title{Scatterplots of feature values against sample covariates}
\usage{
plot_data_vs_cov(
  object,
  covariate = 1,
  warped = TRUE,
  factor = 1,
  view = 1,
  groups = "all",
  features = 10,
  sign = "all",
  color_by = "group",
  legend = TRUE,
  alpha = 1,
  shape_by = NULL,
  stroke = NULL,
  dot_size = 2.5,
  text_size = NULL,
  add_lm = FALSE,
  lm_per_group = FALSE,
  imputed = FALSE,
  return_data = FALSE
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object using MEFISTO.}

\item{covariate}{string with the covariate name or a samples_metadata column, or an integer with the index of the covariate}

\item{warped}{logical indicating whether to show the aligned covariate (default: TRUE), 
only relevant if warping has been used to align multiple sample groups}

\item{factor}{string with the factor name, or an integer with the index of the factor to take top features from}

\item{view}{string with the view name, or an integer with the index of the view. Default is the first view.}

\item{groups}{groups to plot. Default is "all".}

\item{features}{if an integer (default), the total number of features to plot (given by highest weights). If a character vector, a set of manually-defined features.}

\item{sign}{can be 'positive', 'negative' or 'all' (default) to show only features with highest positive, negative or all weights, respectively.}

\item{color_by}{specifies groups or values (either discrete or continuous) used to color the dots (samples). This can be either: 
\itemize{
\item the string "group": dots are coloured with respect to their predefined groups.
\item a character giving the name of a feature that is present in the input data 
\item a character giving the same of a column in the sample metadata slot
\item a vector of the same length as the number of samples specifying the value for each sample. 
\item a dataframe with two columns: "sample" and "color"
}}

\item{legend}{logical indicating whether to add a legend}

\item{alpha}{numeric indicating dot transparency (default is 1).}

\item{shape_by}{specifies groups or values (only discrete) used to shape the dots (samples). This can be either: 
\itemize{
\item the string "group": dots are shaped with respect to their predefined groups.
\item a character giving the name of a feature that is present in the input data 
\item a character giving the same of a column in the sample metadata slot
\item a vector of the same length as the number of samples specifying the value for each sample. 
\item a dataframe with two columns: "sample" and "shape"
}}

\item{stroke}{numeric indicating the stroke size (the black border around the dots, default is NULL, inferred automatically).}

\item{dot_size}{numeric indicating dot size (default is 5).}

\item{text_size}{numeric indicating text size (default is 5).}

\item{add_lm}{logical indicating whether to add a linear regression line for each plot}

\item{lm_per_group}{logical indicating whether to add a linear regression line separately for each group}

\item{imputed}{logical indicating whether to include imputed measurements}

\item{return_data}{logical indicating whether to return a data frame instead of a plot}
}
\value{
Returns a \code{ggplot2} object or the underlying dataframe if return_data is set to \code{TRUE}.
}
\description{
Function to do a scatterplot of features against sample covariate values.
}
\details{
One of the first steps for the annotation of factors is to visualise the weights using \code{\link{plot_weights}} or \code{\link{plot_top_weights}}
and inspect the relationship of the factor to the covariate(s) using  \code{\link{plot_factors_vs_cov}}.
However, one might also be interested in visualising the direct relationship between features and covariate(s), rather than looking at "abstract" weights and
possibly look at the interpolated and extrapolated values by setting imputed to True.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "MEFISTO_model.hdf5", package = "MOFA2")
model <- load_model(file)
plot_data_vs_cov(model, factor = 3, features = 2)
}
