% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeDeletion.R
\name{visualizeDeletion}
\alias{visualizeDeletion}
\title{Visualization for deletions}
\usage{
visualizeDeletion(deletion, bins, metaData, mCounts, md, save = FALSE)
}
\arguments{
\item{deletion}{A GRanges object in the format of the output of 
denovoDeletions().}

\item{bins}{The set of bins determined by calcBins().}

\item{metaData}{A table in the format of the output of getMetaData().}

\item{mCounts}{A matrix of normalized coverage output by normalizedCounts().}

\item{md}{The minimum distance matrix output by calcMD()}

\item{save}{If TRUE will save plot to current working directory instead of 
rendering.}
}
\value{
The file name if the plot was saved.
}
\description{
This function plots the raw read information from the location of interest 
for a trio.
}
\examples{
\dontrun{
load(system.file("extdata", 'bins.RData', package = "MDTS"))
load(system.file("extdata", 'counts.RData', package = "MDTS"))
load(system.file("extdata", 'pD.RData', package = "MDTS"))
mCounts <- normalizeCounts(counts, bins)
md <- calcMD(mCounts, pD)
cbs <- segmentMD(md, bins)
denovo <- denovoDeletions(cbs, mCounts, bins)
visualizeDeletion(denovo[1], bins, pD, mCounts, md)
}
}
\keyword{visualizeDeletion}
