% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMD.R
\name{calcMD}
\alias{calcMD}
\title{Calculating the Minimum Distance matrix}
\usage{
calcMD(mCounts, metaData)
}
\arguments{
\item{mCounts}{A matrix of normalized coverage output by normalizedCounts().}

\item{metaData}{A table in the format of the output of metaData().}
}
\value{
A \code{data.frame} of minimum distances. Each column is a trio,
while each row is an entry in \code{bins}
}
\description{
This function will return a matrix of minimum distances where ecah column is 
a family, and each row is a bin.
}
\examples{
load(system.file("extdata", 'bins.RData', package = "MDTS"))
load(system.file("extdata", 'counts.RData', package = "MDTS"))
load(system.file("extdata", 'pD.RData', package = "MDTS"))
mCounts <- normalizeCounts(counts, bins)
md <- calcMD(mCounts, pD)
}
\keyword{calcMD}
