% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcBins.R
\name{calcBins}
\alias{calcBins}
\title{Sample driven calculation of bins for counting}
\usage{
calcBins(metaData, n, readLength, medianCoverage, minimumCoverage, genome,
  mappabilityFile, seed = 1337)
}
\arguments{
\item{metaData}{A table in the format of the output of getMetaData().}

\item{n}{The number of subsamples to use.}

\item{readLength}{The read length of the experiment.}

\item{medianCoverage}{The median number of reads across sub-samples to reach 
before creating a new bin.}

\item{minimumCoverage}{The miminum number of coverage across all sub-samples 
required to create the proto-region.}

\item{genome}{The BSGenome object that assists in calculations of the GC 
content of the bins.}

\item{mappabilityFile}{A path to the bigwig file of 100mer mappability of the
corresponding genome.}

\item{seed}{Sets the seed so results are reproducible. Defaults to 1337.}
}
\value{
Returns a \code{GRanges} object depicting the dynamic bins that MDTS 
calculates.
}
\description{
This function will randomly select a sample of bam files to calculate dynamic
MDTS bins for subsequent read-depth analysis.
}
\examples{
load(system.file("extdata", 'bins.RData', package = "MDTS"))
bins
}
\keyword{calcBins}
