% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PointScore.R
\name{PointScoreCalc}
\alias{PointScoreCalc}
\title{Calculate PointScore}
\usage{
PointScoreCalc(gene.expr.matrix, gene.loc1, gene.loc2)
}
\arguments{
\item{gene.expr.matrix}{Gene expression matrix with genes as rows and samples as columns}

\item{gene.loc1}{Location of the rows containing the genes in gene set 1 within the gene expression matrix}

\item{gene.loc2}{Location of the rows containing the genes in gene set 2 within the gene expression matrix}
}
\value{
Vector of point scores for each sample in the gene expression matrix
}
\description{
Using two gene sets that are represented of a known bicluster (one gene set being 
up regulated while other gene set is down regulated), samples are scored based
on how well they match the known regulation of the bicluster.
}
\details{
The PointScore of a sample can be directly compared to the PC1 value. The PointScore
is typically used to identify samples related to the upper/lower fork  of a bicluster
without running the complete main MCbiclust pipeline on a dataset.
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- (row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

set.seed(102)
CCLE.seed <- FindSeed(gem = CCLE.mito,
                      seed.size = 10,
                      iterations = 100,
                      messages = 1000)

CCLE.sort <- SampleSort(gem = CCLE.mito,seed = CCLE.seed,sort.length = 11)

# Full ordering are in Vignette_sort in sysdata.rda
CCLE.samp.sort <- MCbiclust:::Vignette_sort[[1]]

CCLE.pc1 <- PC1VecFun(top.gem = CCLE.mito,
                      seed.sort = CCLE.samp.sort,
                      n = 10)

CCLE.hicor.genes <- as.numeric(HclustGenesHiCor(CCLE.mito,
                                                CCLE.seed,
                                                cuts = 8))

CCLE.cor.mat <- cor(t(CCLE.mito[CCLE.hicor.genes,CCLE.seed]))

gene.set1 <- labels(as.dendrogram(hclust(dist(CCLE.cor.mat)))[[1]])
gene.set2 <- labels(as.dendrogram(hclust(dist(CCLE.cor.mat)))[[2]])

gene.set1.loc <- which(row.names(CCLE.mito) \%in\% gene.set1)
gene.set2.loc <- which(row.names(CCLE.mito) \%in\% gene.set2)

ps.vec <- PointScoreCalc(CCLE.mito,gene.set1.loc,gene.set2.loc)

cor(ps.vec[CCLE.samp.sort], CCLE.pc1)
plot(ps.vec[CCLE.samp.sort])
plot(CCLE.pc1)
}
