% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOEnrichmentAnalysis.R
\name{GOEnrichmentAnalysis}
\alias{GOEnrichmentAnalysis}
\alias{GOEnrichmentAnalysis}
\title{Calculate gene set enrichment of correlation vector using Mann-Whitney test}
\usage{
GOEnrichmentAnalysis(gene.names, gene.values, sig.rate)
}
\arguments{
\item{gene.names}{Names of the genes in standard gene name format.}

\item{gene.values}{Values associated with the genes, e.g the correlation vector
output of \code{CVEval}.}

\item{sig.rate}{Level of significance required after multiple hypothesis
adjustment.}
}
\value{
Data frame of the significant gene sets, with GOID, GO Term, number
 of genes, number of genes in GO Term, number of genes in GO Term also in
 gene set, adjusted p-value, average value of correlation vector in gene set
 and phenotype describing whether average value of correlation vector is
 above or below the total average.
}
\description{
The Mann-Whitney test is typically used due to the values of the correlation
 vector, not being normally distributed. \code{GOEnrichmentAnalysis} provides 
 an interface  with the GO database annotation to find the most significant GO
 terms.
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- (row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

set.seed(101)
CCLE.seed <- FindSeed(gem = CCLE.mito,
                      seed.size = 10,
                      iterations = 100,
                      messages = 100)

CCLE.cor.vec <- CVEval(gem.part = CCLE.mito,
                       gem.all = CCLE_small,
                       seed = CCLE.seed, splits = 10)

# Significant GO terms can be calculated as follows:
# GEA <- GOEnrichmentAnalysis(gene.names = row.names(CCLE_small),
#                            gene.values = CCLE.cor.vec,
#                            sig.rate = 0.05)

}
