% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbqnBoxplot.R
\name{mbqnBoxplot}
\alias{mbqnBoxplot}
\title{Combined box plot and line plot}
\usage{
mbqnBoxplot(mtx, irow = NULL, vals = NULL, add.leg = TRUE, ...)
}
\arguments{
\item{mtx}{a matrix or data frame.}

\item{irow}{index or vector of row indices of matrix features to plot on top
of the boxplot.}

\item{vals}{numeric, array, matrix, or data frame of features with length
\code{ncol(mtx)} to plot on top of the boxplot.}

\item{add.leg}{add legend to plot.}

\item{...}{additional arguments passed to the plot functions, e.g. xlab,
ylab, main, ylim, type, las.}
}
\value{
Figure.
}
\description{
Create a box-and-whisker plot of a data matrix and
plot selected features and/or additional user-defined data on top of it.
}
\details{
This function calls \code{graphics::boxplot}.
Groups are represent by matrix columns. Selected rows/features or
user-defined arrays are plot on top of the box plot. Missing values are
ignored.
}
\examples{
## Create boxplot of quantile normalized data matrix and plot
## feature from median balanced quantile normalization on top of it.
X <- matrix(c(5,2,3,NA,4,1,4,2,3,4,6,NA,1,3,1),ncol=3) # Create data matrix
# Quantile normalization
qn.dat <- mbqn(x=X,FUN = NULL ,na.rm = TRUE)
# Median balanced quantile normalization
mbqn.dat <- mbqn(x=X,FUN = median ,na.rm = TRUE)
## Create boxplot:
plot.new()
mbqnBoxplot(qn.dat,irow = 1, vals = mbqn.dat[1,], type = "b")
}
\references{
Brombacher, E., Schad, A., Kreutz, C. (2020). Tail-Robust
Quantile Normalization. BioRxiv.
}
\author{
Ariane Schad
}
\concept{example}
