% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_plots.R
\name{mbecVarianceStatsPlot}
\alias{mbecVarianceStatsPlot}
\title{Plot Proportion of Variance for L(M)M}
\usage{
mbecVarianceStatsPlot(variance.obj)
}
\arguments{
\item{variance.obj, }{output of 'mbecVarianceStats' with method lm}
}
\value{
A ggplot2 box-plot object.
}
\description{
Covariate-Variances as modeled by linear (mixed) models will be displayed as
box-plots. It works with the output of 'mbecVarianceStats()' for methods 'lm'
and 'lmm'. Format of this output is a data.frame that contains a column for
every model variable and as many rows as there are features
(OTUs, Genes, ..). Multiple frames may be used as input by putting them into
a list - IF the data.frames contain a column named 'type', this function will
use 'facet_grid()' to display side-by-side panels to enable easy comparison.
}
\examples{
# This will return a paneled plot that shows results for the variance
# assessments.
data(dummy.mbec)
df.var.lm <- mbecModelVariance(input.obj=dummy.mbec,
model.vars=c('group','batch'), method='lm', type='clr')
plot.lm <- mbecVarianceStatsPlot(variance.obj=df.var.lm)
}
\keyword{linear}
\keyword{mixed}
\keyword{models}
\keyword{plot}
\keyword{proportion}
\keyword{variance}
