% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{mbecValidateModel}
\alias{mbecValidateModel}
\title{Validate Linear (Mixed) Models}
\usage{
mbecValidateModel(model.fit, colinearityThreshold = 0.999)
}
\arguments{
\item{model.fit}{lm() or lmm() output.}

\item{colinearityThreshold}{Cut-off for model rejection, I=[0,1].}
}
\value{
No return values. Stops execution if validation fails.
}
\description{
A helper function that calculates the collinearity between model variables
and stops execution, if the maximum value is bigger than the allowed
threshold.
}
\details{
ToDo: maybe some additional validation steps and more informative output.
}
\examples{
# This will just go through if colinearity threshold is met.
data(dummy.list)
limimo <- lme4::lmer(dummy.list$cnts[,1] ~ group + (1|batch),
data=dummy.list$meta)
mbecValidateModel(model.fit=limimo, colinearityThreshold=0.999)
}
\keyword{collinearity}
\keyword{model}
\keyword{validation}
