% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_classes.R
\name{mbecProcessInput,list-method}
\alias{mbecProcessInput,list-method}
\title{Mbec-Data Constructor Wrapper}
\usage{
\S4method{mbecProcessInput}{list}(input.obj, required.col = NULL)
}
\arguments{
\item{input.obj}{One of MbecData, phyloseq or list(counts, meta-data).}

\item{required.col}{Vector of column names that need to be present in the
meta-data table.}
}
\value{
An object of type MbecData that has been validated.
}
\description{
This function is a wrapper for the constructor of MbecData-objects from
phyloseq objects and lists of counts and sample data.
}
\details{
The (OPTIONAL) argument 'required.col' is a vector of column-names that will
enable a sanity test for the presence in the meta-data table. Which is also
the second use-case for objects that are already of class MbecData.
}
\examples{
# This will check for the presence of variables 'group' and 'batch' in the
# meta-data and return an object of class 'MbecData'.
data(dummy.mbec)
MbecData.obj <- mbecProcessInput(input.obj=dummy.mbec,
    required.col=c("group","batch"))
}
\keyword{Constructor}
\keyword{MBECS}
\keyword{Wrapper}
