% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{mbecModelVarianceLMM}
\alias{mbecModelVarianceLMM}
\title{Estimate Explained Variance with Linear Mixed Models}
\usage{
mbecModelVarianceLMM(model.form, model.vars, tmp.cnts, tmp.meta, type)
}
\arguments{
\item{model.form}{Formula for linear mixed model, function will create simple
additive linear mixed model if this argument is not supplied.}

\item{model.vars}{Covariates to use for model building if argument
'model.form' is not given.}

\item{tmp.cnts}{Abundance matrix in 'sample x feature' orientation.}

\item{tmp.meta}{Covariate table that contains at least the used variables.}

\item{type}{String the denotes data source, i.e., one of "otu","clr" or "tss"
for the transformed counts or the label of the batch corrected count-matrix.}
}
\value{
Data.frame that contains proportions of variance for given covariates
in a linear mixed modelling approach.
}
\description{
The function uses a linear mixed modeling approach to estimate the
proportion of variance that can be attributed to covariates of interest.
This shows, how much variation is explained by the treatment effect, which
proportion is introduced by processing in batches and the leftover variance,
i.e., residuals that are not currently explained. Covariates of interest
(CoI) are selected by the user and the function will incorporate them into
the model.
}
\details{
Linear Mixed Model (lmm): Only the first covariate is considered a mixed
effect. A model is fitted to each OTU respectively and the proportion of
variance extracted for each covariate.
(OTU_x ~ covariate_2.. + covariate_n + (1|covariate_1)
}
\keyword{LMM}
\keyword{Proportion}
\keyword{Variance}
\keyword{of}
