% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{overlapQTLs}
\alias{overlapQTLs}
\title{overlapQTLs}
\usage{
overlapQTLs(meth.qtl.result.list, type)
}
\arguments{
\item{meth.qtl.result.list}{A named list with each entry being an object of type \code{\link{MethQTLResult-class}}.
The names are used in the visualization.}

\item{type}{Determines if either the SNP (default), the CpG, or the correlation block
\code{'cor.block'} is to be visualized}
}
\value{
A list with \code{length(meth.qtl.result.list)} elements, containing IDs of methQTL
interactions according to the option \code{type}.
}
\description{
This function overlaps a list of methQTLs to determine which interactions are common.
}
\examples{
meth.qtl.res.1 <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
meth.qtl.res.2 <- meth.qtl.res.1
res <- overlapQTLs(list(A=meth.qtl.res.1,B=meth.qtl.res.2),type="SNP")
}
\author{
Michael Scherer
}
