% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethQTLResult-class.R
\docType{methods}
\name{getResultGWASMap,MethQTLResult-method}
\alias{getResultGWASMap,MethQTLResult-method}
\alias{getResultGWASMap}
\title{getResultGWASMap}
\usage{
\S4method{getResultGWASMap}{MethQTLResult}(object, meth.qtl)
}
\arguments{
\item{object}{An of type \code{\link{MethQTLResult-class}}.}

\item{meth.qtl}{An object of type \code{\link{MethQTLInput-class}} containing further information about the QTLs}
}
\value{
The methQTL results as a \code{data.frame} with each row being a methQTL.
}
\description{
Returns the methQTL results in the format used as input to GWAS-map and stores in the object.
}
\examples{
meth.qtl.res <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
meth.qtl <- loadMethQTLInput(system.file("extdata","reduced_methQTL",package="MAGAR"))
head(getResultGWASMap(meth.qtl.res,meth.qtl))
}
