% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinepeak.R
\name{refinepeak}
\alias{refinepeak}
\title{refinepeak}
\usage{
refinepeak(
  bedfile,
  ifile,
  format = c("AUTO", "BAM", "SAM", "BED", "ELAND", "ELANDMULTI", "ELANDEXPORT", "BOWTIE"),
  cutoff = 5,
  windowsize = 200L,
  buffer_size = 100000L,
  verbose = 2L,
  outdir = "./",
  outputfile = character(),
  oprefix = character(),
  log = TRUE
)
}
\arguments{
\item{bedfile}{Candidate peak file in BED format. REQUIRED.}

\item{ifile}{ChIP-seq alignment file. If multiple files are given
as '-t A B C', then they will all be read and combined. Note
that pair-end data is not supposed to work with this
command. REQUIRED.}

\item{format}{Format of tag file, \"AUTO\", \"BED\" or \"ELAND\" or
\"ELANDMULTI\" or \"ELANDEXPORT\" or \"SAM\" or \"BAM\" or
\"BOWTIE\". The default AUTO option will let '\%(prog)s' decide
which format the file is. Please check the definition in README
file if you choose
ELAND/ELANDMULTI/ELANDEXPORT/SAM/BAM/BOWTIE. DEFAULT: \"AUTO\""}

\item{cutoff}{Cutoff. Regions with SPP wtd score lower than cutoff will not be considerred.  DEFAULT: 5}

\item{windowsize}{Scan window size on both side of the summit
(default: 100bp)}

\item{buffer_size}{Buffer size for incrementally increasing
internal array size to store reads alignment information. In
most cases, you don't have to change this parameter. However,
if there are large number of chromosomes/contigs/scaffolds in
your alignment, it's recommended to specify a smaller buffer
size in order to decrease memory usage (but it will take longer
time to read alignment files). Minimum memory requested for
reading an alignment file is about # of CHROMOSOME *
BUFFER_SIZE * 8 Bytes. DEFAULT: 100000}

\item{verbose}{Set verbose level. 0: only show critical message, 1:
show additional warning message, 2: show process information,
3: show debug messages. If you want to know where are the
duplicate reads, use 3. DEFAULT:2}

\item{outdir}{Output file name. Mutually exclusive with --o-prefix.}

\item{outputfile}{Output bedGraph file name. If not specified, will
write to standard output. REQUIRED.}

\item{oprefix}{Output file prefix. Mutually exclusive with -o/--ofile.}

\item{log}{Whether to capture logs.}
}
\value{
\code{macsList} object.
}
\description{
Take raw reads alignment, refine peak summits. Inspired by SPP.
}
\examples{
eh <- ExperimentHub::ExperimentHub()
CHIP <- eh[["EH4558"]]
CTRL <- eh[["EH4563"]]
res <- callpeak(CHIP, CTRL, gsize = 5.2e7, cutoff_analysis = TRUE,
                outdir = tempdir(), name = "callpeak_narrow0")
refinepeak(grep("narrowPeak", res$outputs, value = TRUE), CHIP,
           outdir = tempdir(), outputfile = "refine")
}
