% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callvar.R
\name{callvar}
\alias{callvar}
\title{callvar}
\usage{
callvar(
  peakbed,
  tfile,
  cfile,
  outputfile = character(),
  GQCutoffHetero = 0,
  GQCutoffHomo = 0,
  Q = 20,
  maxDuplicate = 1L,
  fermi = "auto",
  fermiMinOverlap = 30L,
  top2allelesMinRatio = 0.8,
  altalleleMinCount = 2L,
  maxAR = 0.95,
  np = 1L,
  verbose = 2L,
  log = TRUE
)
}
\arguments{
\item{peakbed}{Peak regions in BED format, sorted by
coordinates. REQUIRED.}

\item{tfile}{ChIP-seq/ATAC-seq treatment file in BAM format, sorted by coordinates. Make sure the .bai file is avaiable in the same directory. REQUIRED.}

\item{cfile}{Optional control file in BAM format, sorted by coordinates. Make sure the .bai file is avaiable in the same directory.}

\item{outputfile}{Output VCF file name.}

\item{GQCutoffHetero}{Genotype Quality score
(-10log10((L00+L11)/(L01+L00+L11))) cutoff for Heterozygous
allele type. Default:0, or there is no cutoff on GQ.}

\item{GQCutoffHomo}{Genotype Quality score
(-10log10((L00+L01)/(L01+L00+L11))) cutoff for Homozygous
allele (not the same as reference) type. Default:0, or ther is
no cutoff on GQ.}

\item{Q}{Only consider bases with quality score greater than this
value. Default: 20, which means Q20 or 0.01 error rate.}

\item{maxDuplicate}{Maximum duplicated reads allowed per mapping
position, mapping strand and the same CIGAR code. Default:
1. When sequencing depth is high, to set a higher value might
help evaluate the correct allele ratio.}

\item{fermi}{Option to control when to apply local assembly through fermi-lite. By default (set as 'auto'), while callvar detects any INDEL variant in a peak region, it will utilize fermi-lite to recover the actual DNA sequences to refine the read alignments. If set as 'on', fermi-lite will be always invoked. It can increase specificity however sensivity and speed will be significantly lower. If set as 'off', Fermi won't be invoked at all. If so, speed and sensitivity can be higher but specificity will be significantly lower. Default: auto}

\item{fermiMinOverlap}{The minimal overlap for fermi to initially
assemble two reads. Must be between 1 and read length. A longer
fermiMinOverlap is needed while read length is small (e.g. 30
for 36bp read, but 33 for 100bp read may work). Default:30}

\item{top2allelesMinRatio}{The reads for the top 2 most frequent
alleles (e.g. a ref allele and an alternative allele) at a loci
shouldn't be too few comparing to total reads mapped. The
minimum ratio is set by this optoin. Must be a float between
0.5 and 1.  Default:0.8 which means at least 80\%\% of reads
contain the top 2 alleles.}

\item{altalleleMinCount}{The count of the alternative
(non-reference) allele at a loci shouldn't be too few. By
default, we require at least two reads support the alternative
allele. Default:2}

\item{maxAR}{The maximum Allele-Ratio allowed while calculating
likelihood for allele-specific binding. If we allow higher
maxAR, we may mistakenly assign some homozygous loci as
heterozygous. Default:0.95}

\item{np}{CPU used for mutliple processing. Please note that,
assigning more CPUs does not guarantee the process being
faster. Creating too many parrallel processes need memory
operations and may negate benefit from multi
processing. Default: 1}

\item{verbose}{Set verbose level of runtime message. 0: only show
critical message, 1: show additional warning message, 2: show
process information, 3: show debug messages. DEFAULT:2}

\item{log}{Whether to capture logs.}
}
\value{
\code{macsList} object.
}
\description{
Call variants in given peak regions from the alignment BAM files.
}
\examples{
\dontrun{
callvar(
"PEsample_peaks_sorted.bed",
"PEsample_peaks_sorted.bam",
"PEcontrol_peaks_sorted.bam",
"/tmp/test.vcf")
}
}
