% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calOverlaps_slr.R
\name{calOverlaps_slr}
\alias{calOverlaps_slr}
\title{Compute overlaps for single-label replicate statistics (SLR).}
\usage{
calOverlaps_slr(D, pD, nrow, N, N_len, niter, mat_obs, mat_perm)
}
\arguments{
\item{D}{Numeric matrix of observed statistics/features.}

\item{pD}{Numeric matrix of permuted statistics/features.}

\item{nrow}{Integer, number of features per resample block.}

\item{N}{Integer vector of "top list sizes" for overlap.}

\item{N_len}{Integer, length of N.}

\item{niter}{Numeric, total number of bootstrap/permutation rounds.}

\item{mat_obs}{Matrix (niter x length(N)) to be filled with
overlaps (observed).}

\item{mat_perm}{Matrix (niter x length(N)) to be filled with
overlaps (permuted).}
}
\value{
List with mat_obs=overlaps (observed) and
mat_perm=overlaps (permuted).
}
\description{
Compute overlaps for single-label replicate statistics (SLR).
}
