% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimizing.R
\name{Optimizing}
\alias{Optimizing}
\title{Optimize Parameters Based on Overlap Calculations}
\usage{
Optimizing(
  niter,
  smoothing_constants,
  top_n_values,
  observed_data,
  observed_std_errors,
  permuted_data,
  permuted_std_errors,
  verbose
)
}
\arguments{
\item{niter}{Integer. Number of bootstrap samples or resampling iterations.}

\item{smoothing_constants}{Numeric vector. Smoothing constants to be evaluated.}

\item{top_n_values}{Integer vector. Number of top values to consider for overlap
calculation.}

\item{observed_data}{Numeric matrix. Observed data values.}

\item{observed_std_errors}{Numeric matrix. Standard errors or related values for observed data.}

\item{permuted_data}{Numeric matrix. Permuted data values.}

\item{permuted_std_errors}{Numeric matrix. Standard errors or related values for
permuted data.}

\item{verbose}{Logical. If \code{TRUE}, progress messages will be displayed.}
}
\value{
A list containing the optimal parameters:
\itemize{
\item \code{optimal_smoothing_constant}: Optimal smoothing constant or 1
for SLR (a1).
\item \code{use_smoothing_flag}: SLR flag (1 if smoothing constant is
optimal, 0 if SLR is optimal) (a2).
\item \code{optimal_top_n}: Optimal number of top values to consider
for overlap (k).
\item \code{optimal_reproducibility}: Optimal overlap value (R).
\item \code{optimal_z_score}: Optimal z-score (Z).
\item \code{z_score_table}: Matrix of z-scores for all
evaluated parameters (ztable).
}
}
\description{
This function optimizes parameters by calculating overlaps between observed
and permuted data for multiple values of a smoothing constant and a
single-label replicate (SLR) comparison.
}
\details{
The function calculates overlaps for a range of smoothing constants and
identifies the optimal set of parameters by maximizing a z-score-based
metric, which compares the overlap of observed data to permuted data.
It computes overlap matrices for both observed and permuted data and
returns the optimal parameters based on the highest z-score.
}
