% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneByName.R
\name{plotGeneByName}
\alias{plotGeneByName}
\title{plotGeneByName}
\usage{
plotGeneByName(
  geneName,
  mae,
  filename = NULL,
  text4Title = NULL,
  plotGrid = TRUE,
  figs = c(2, 2)
)
}
\arguments{
\item{geneName}{The name of the gene to be plotted.}

\item{mae}{A MultiAssayExperiment object containing the methylation
and expression data for the specified gene.}

\item{filename}{If provided, the name of the file to save the results
as a PDF; defaults to NULL.}

\item{text4Title}{A string used as the main title for the plot. Defaults to 
`geneName` if set to NULL.}

\item{plotGrid}{A boolean parameter indicating whether to pass
the grid option to the `plotGeneSel` function.}

\item{figs}{A two-component vector defining the 2-dimensional structure of
the plots to be generated.}
}
\value{
a pdf with scatterplots of selected by gene name
}
\description{
\code{plotGeneByName} plots points on a scatterplot with a 3x3 grid
superimposed. The name of a the gene is provided jointly with the
MultiAssayExperiment object and used to select the row to be plotted.
}
\examples{
# Plot gene by name based on example data
# Methylation data
methylData <- matrix(runif(50), nrow = 10)
colnames(methylData) <- paste0("samp", 1:ncol(methylData))
rownames(methylData) <- paste0("gene", 1:nrow(methylData))
# Expression data
expresData <- matrix(rnorm(50), nrow = 10)
colnames(expresData) <- paste0("samp", 1:ncol(methylData))
rownames(expresData) <- paste0("gene", 1:nrow(methylData))
# ColData
colDat <- data.frame(
    sampleID = colnames(methylData),
    name = letters[1:ncol(methylData)]
)

rownames(colDat) <- colDat$sampleID
mae <- MultiAssayExperiment::MultiAssayExperiment(
    experiments = list(
        methylation = methylData,
        expression = expresData
    ),
    colData = colDat
)
plotGeneByName(gene = "gene7", mae = mae)

}
\keyword{gene}
\keyword{name}
\keyword{plot}
