% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LACHESIS.R
\name{classifyLACHESIS}
\alias{classifyLACHESIS}
\title{Classify a tumor's start of clonal outgrowth during tumorigenesis as "early"
or "late" (favorable/ unfavorable prognosis) depending on the mutation
density at its MRCA}
\usage{
classifyLACHESIS(
  lachesis,
  mrca.cutpoint = NULL,
  output.dir = NULL,
  infer.cutpoint = FALSE,
  entity = "neuroblastoma",
  surv.time = "OS.time",
  surv.event = "OS"
)
}
\arguments{
\item{lachesis}{output generated from \code{\link{LACHESIS}}.}

\item{mrca.cutpoint}{optional; value based on SNV_densities_cohort.pdf
observation, will be used as inferred from a test data set if not specified
by user.}

\item{output.dir}{link to directory in which output is to be stored.}

\item{infer.cutpoint}{logical; should the MRCA cutpoint be inferred from the
data?}

\item{entity}{optional; the tumor entity if classifying according to a
pre-defined threshold. Currently, only "neuroblastoma" is supported.}

\item{surv.time}{column name containing survival time; defaults to \code{OS.time}.}

\item{surv.event}{column name containing event; defaults to \code{OS}.}
}
\value{
data.table with binary assignment early/ late
}
\description{
Takes SNV density timing as computed by \code{LACHESIS} as input and classifies
the tumors in the cohort.
}
\examples{
# An example file with sample annotations and meta data
input.files <- system.file("extdata", "Sample_template.txt",
    package = "LACHESIS"
)
input.files <- data.table::fread(input.files)

# cnv and snv files for example tumors
nbe11 <- list.files(system.file("extdata/NBE11/", package = "LACHESIS"),
    full.names = TRUE
)
nbe15 <- list.files(system.file("extdata/NBE15/", package = "LACHESIS"),
    full.names = TRUE
)
nbe26 <- list.files(system.file("extdata/NBE26/", package = "LACHESIS"),
    full.names = TRUE
)

cnv.file <- c(nbe11[1], nbe15[1], nbe26[1])
snv.file <- c(nbe11[2], nbe15[2], nbe26[2])

input.files$cnv.file <- cnv.file
input.files$snv.file <- snv.file

# Make an example input file with paths to cnv and snv file along with other
# meta data
lachesis_input <- tempfile(
    pattern = "lachesis", tmpdir = tempdir(),
    fileext = ".tsv"
)
data.table::fwrite(x = input.files, file = lachesis_input, sep = "\t")

# Example with template file with paths to multiple cnv/snv files as an input
lachesis <- LACHESIS(input.files = lachesis_input)
classifyLACHESIS(lachesis)

}
