% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_genes_by_cell_type.R
\name{path_genes_by_cell_type}
\alias{path_genes_by_cell_type}
\title{See how many pathway gene knock-outs are available from data}
\usage{
path_genes_by_cell_type(KEGG_mappings, pert_time = 96, get_KOs = FALSE,
  generate_plot = TRUE)
}
\arguments{
\item{KEGG_mappings}{KEGG_mappings The data.frame object generated by the 
function expand_KEGG_mappings}

\item{pert_time}{Choose from (6,24,48,96,120,144,168)}

\item{get_KOs}{Logical indicator to have data frame returned}

\item{generate_plot}{Logical indicator to generate histogram}
}
\value{
A plot depicting percentage of pathway genes knocked-out by 
cell line and a data frame object listing the genes [by cell line]
}
\description{
Check quantity of data across cell lines available from LINCS
 corresponding to the pathway of interest
}
\examples{
p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <- expand_KEGG_mappings(p53_KGML)

path_genes_by_cell_type(p53_KEGG_mappings)
}
