% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineSignalsWithLoops.R
\name{combineWithLoops}
\alias{combineWithLoops}
\title{Preparation for correlation analysis via loops}
\usage{
combineWithLoops(object, loopsInitDf, fragmentLength = 0, tssWidth = 2000,
  extSize = 0)
}
\arguments{
\item{object}{InTADSig object}

\item{loopsInitDf}{Data frame with loops. By default 6-column format
\emph{(chr1,start1,end1,chr2,start2,pos2)} is expected.}

\item{fragmentLength}{In case the input format is 4-column \emph{(chr1,middlePos1,
chr2, middlePos2)} fragment length should be provided to extend the
corresponding loci for loop start and end positions.}

\item{tssWidth}{The transcription start site width is used to control overlaps
with loop anchor. Default is 2000 base pairs.}

\item{extSize}{The loop endings can be extended upstream and downstream
with provided corresponding increase size in base pairs.}
}
\value{
Updated InTADSig object containing genes connected to signals
via loops
}
\description{
This function combines signals and genes based on the usage
of loops obtained from HiC data analysis
}
\details{
The expected input is the loops data.frame applied to find
connections of signals to genes. This data.frame could be
in two formats: either \emph{(chr1,start1,end1,chr2,start2,end2)} or
\emph{(chr1,middlePos1,chr2,middlePos2)} with fragment size.
}
