% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineSignalsInTAD.R
\name{combineInTAD}
\alias{combineInTAD}
\title{Preparation for correlation analysis}
\usage{
combineInTAD(object, tadGR, selMaxTadOvlp = TRUE, closestGene = TRUE)
}
\arguments{
\item{object}{InTADSig object}

\item{tadGR}{TAD genomic regions}

\item{selMaxTadOvlp}{If a signal overlaps 2 or more TADs by default only
single TAD with max overlap is selected.All overlaps can be included by
deactivating this option.}

\item{closestGene}{By default closest to TAD genes are selected based
on TSS location. Deactivate this option to use genes only lying within TAD.}
}
\value{
Updated InTADSig object containing genes connected to eash signal
}
\description{
This function combines signals and genes in inside of
Topologically Associated Domains (TADs)
}
\details{
Each signal is checked if it is lying inside of TAD. Signals out of TADs
are ignored. The genomic regions reprenting gene coordiantes are converted
to TSS. By default, the closest genes are assigned belonging to TAD.
If this option deactivated, only those lying with TAD are collected.
Result is a list of signals connected to tables with gene details.
}
\examples{
# create sigInTAD object
inTadSig <- newSigInTAD(enhSel, enhSelGR, rpkmCountsSel, txsSel)
# combine signals and genes in TAD
inTadSig <- combineInTAD(inTadSig, tadGR)


}
