% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00.get_lastCDSUTR3.R
\name{get_lastCDSUTR3}
\alias{get_lastCDSUTR3}
\title{Extract the last unspliced region of each transcript}
\usage{
get_lastCDSUTR3(
  TxDb = getInPASTxDb(),
  genome = getInPASGenome(),
  chr2exclude = getChr2Exclude(),
  outdir = getInPASOutputDirectory(),
  MAX_EXONS_GAP = 10000
)
}
\arguments{
\item{TxDb}{An object of \link[GenomicFeatures:TxDb-class]{GenomicFeatures::TxDb}}

\item{genome}{An object of \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}}

\item{chr2exclude}{A character vector, NA or NULL, specifying chromosomes or
scaffolds to be excluded for InPAS analysis. \code{chrM} and alternative scaffolds
representing different haplotypes should be excluded.}

\item{outdir}{A character(1) vector, a path with write permission for storing
InPAS analysis results. If it doesn't exist, it will be created.}

\item{MAX_EXONS_GAP}{An integer(1) vector, maximal gap sizes between the last
known CP sites to a nearest downstream exon. Default is 10 kb for mammalian
genomes. For other species, user need to adjust this parameter.}
}
\value{
A BED file with 6 columns: chr, chrStart, chrEnd, name, score, and
strand.
}
\description{
Extract the last unspliced region of each transcript from a TxDb. These
regions could be the last 3'UTR exon for transcripts whose 3' UTRs are
composed of multiple exons or last CDS regions and 3'UTRs for transcripts
whose 3'UTRs and last CDS regions are on the same single exon.
}
