% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05.assemble_allCov.R
\name{assemble_allCov}
\alias{assemble_allCov}
\title{Assemble coverage files for a given chromosome for all samples}
\usage{
assemble_allCov(
  sqlite_db,
  seqname,
  outdir = getInPASOutputDirectory(),
  genome = getInPASGenome()
)
}
\arguments{
\item{sqlite_db}{A path to the SQLite database for InPAS, i.e.
the output of setup_sqlitedb()}

\item{seqname}{A character(1) vector, the name of a chromosome/scaffold}

\item{outdir}{A character(1) vector, a path with write permission for storing
InPAS analysis results. If it doesn't exist, it will be created.}

\item{genome}{An object of \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}}
}
\value{
A list of paths to per-chromosome coverage files of all samples.
\itemize{\item seqname, chromosome/scaffold name
\itemize{
\item  tag1, name tag for sample1
\item  tag2, name tag for sample2
\item  tagN, name tag for sampleN
}
}
}
\description{
Process individual sample-chromosome-specific coverage files in an
experiment into a file containing a list of chromosome-specific Rle
coverage of all samples
}
\examples{
if (interactive()) {
  library(BSgenome.Mmusculus.UCSC.mm10)
  genome <- BSgenome.Mmusculus.UCSC.mm10
  bedgraphs <- system.file("extdata", c(
    "Baf3.extract.bedgraph",
    "UM15.extract.bedgraph"
  ),
  package = "InPAS"
  )
  tags <- c("Baf3", "UM15")
  metadata <- data.frame(
    tag = tags,
    condition = c("Baf3", "UM15"),
    bedgraph_file = bedgraphs
  )
  outdir <- tempdir()
  write.table(metadata,
    file = file.path(outdir, "metadata.txt"),
    sep = "\t", quote = FALSE, row.names = FALSE
  )

  sqlite_db <- setup_sqlitedb(
    metadata = file.path(
      outdir,
      "metadata.txt"
    ),
    outdir
  )
  coverage <- list()
  addLockName(filename = tempfile())
  for (i in seq_along(bedgraphs)) {
    coverage[[tags[i]]] <- get_ssRleCov(
      bedgraph = bedgraphs[i],
      tag = tags[i],
      genome = genome,
      sqlite_db = sqlite_db,
      outdir = outdir,
      chr2exclude = "chrM"
    )
  }
  chr_coverage <- assemble_allCov(sqlite_db,
    seqname = "chr6",
    outdir = outdir,
    genome = genome
  )
}
}
\author{
Haibo Liu
}
