% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{top_abund_tableGrob}
\alias{top_abund_tableGrob}
\title{Summary top abundant tableGrobs for plots.}
\usage{
top_abund_tableGrob(
  df,
  id_cols = mandatory_IS_vars(),
  quant_col = "fragmentEstimate_sum_PercAbundance",
  by = "TimePoint",
  alluvial_plot = NULL,
  top_n = 10,
  tbl_cols = "GeneName",
  include_id_cols = FALSE,
  digits = 2,
  perc_symbol = TRUE,
  transform_by = NULL
)
}
\arguments{
\item{df}{A data frame}

\item{id_cols}{Character vector of id column names. To plot after alluvial,
these columns must be the same as the \code{alluvia} argument of
\link{integration_alluvial_plot}.}

\item{quant_col}{Column name holding the quantification value.
To plot after alluvial,
these columns must be the same as the \code{plot_y} argument of
\link{integration_alluvial_plot}.}

\item{by}{The column name to subdivide tables for. The function
will produce one table for each distinct value in \code{by}.
To plot after alluvial,
these columns must be the same as the \code{plot_x} argument of
\link{integration_alluvial_plot}.}

\item{alluvial_plot}{Either NULL or an alluvial plot for color mapping
between values of y.}

\item{top_n}{Integer. How many rows should the table contain at most?}

\item{tbl_cols}{Table columns to show in the final output besides
\code{quant_col}.}

\item{include_id_cols}{Logical. Include \code{id_cols} in the output?}

\item{digits}{Integer. Digits to show for the quantification column}

\item{perc_symbol}{Logical. Show percentage symbol in the quantification
column?}

\item{transform_by}{Either a function or a purrr-style lambda. This
function is applied to the column \code{by} before separating columns. If
\code{NULL} no function is applied. Useful to modify column order in final table.}
}
\value{
A tableGrob object
}
\description{
Produce summary tableGrobs as R graphics. For this functionality
the suggested package
\href{https://cran.r-project.org/web/packages/gridExtra/index.html}{gridExtra}
is required. To visualize the resulting object:

\if{html}{\out{<div class="sourceCode">}}\preformatted{gridExtra::grid.arrange(tableGrob)
}\if{html}{\out{</div>}}
}
\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
abund <- compute_abundance(x = aggreg)
grob <- top_abund_tableGrob(abund)
gridExtra::grid.arrange(grob)

# with transform
grob <- top_abund_tableGrob(abund, transform_by = ~ as.numeric(.x))
}
\seealso{
Other Plotting functions: 
\code{\link{CIS_volcano_plot}()},
\code{\link{HSC_population_plot}()},
\code{\link{circos_genomic_density}()},
\code{\link{fisher_scatterplot}()},
\code{\link{integration_alluvial_plot}()},
\code{\link{sharing_heatmap}()},
\code{\link{sharing_venn}()},
\code{\link{top_cis_overtime_heatmap}()}
}
\concept{Plotting functions}
