% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixptfn.R
\name{.logistic_em}
\alias{.logistic_em}
\title{A fixed-point mapping for the expectation-maximization algorithm.
Used as an argument for fixptfn in the squarem function.}
\usage{
.logistic_em(d_vec, pprobs, alpha)
}
\arguments{
\item{d_vec}{A vector of gene set annotations for the genes of interest.
Entries should be integer(1) if the gene is annotated and integer(0)
otherwise.}

\item{pprobs}{A vector of posterior probabilities for each gene estimated
from the
intact function. Gene order should match d_vec.}

\item{alpha}{A vector containing the current estimates of the enrichment
parameters
alpha0 and alpha1$.}
}
\value{
Updated estimates of alpha0 and alpha1.
}
\description{
A fixed-point mapping for the expectation-maximization algorithm.
Used as an argument for fixptfn in the squarem function.
}
