% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ratePvals-methods.R
\name{calculateRatePvals}
\alias{calculateRatePvals}
\alias{calculateRatePvals,INSPEcT-method}
\title{Calculate a single p-value for each rate}
\usage{
calculateRatePvals(
  object,
  modelSelection = c("aic", "llr", "hib"),
  preferPValue = TRUE,
  padj = TRUE,
  p_goodness_of_fit = 0.1,
  p_variability = rep(0.05, 3),
  limitModelComplexity = FALSE
)

\S4method{calculateRatePvals}{INSPEcT}(
  object,
  modelSelection = c("aic", "llr", "hib"),
  preferPValue = TRUE,
  padj = TRUE,
  p_goodness_of_fit = 0.1,
  p_variability = rep(0.05, 3),
  limitModelComplexity = FALSE
)
}
\arguments{
\item{object}{An object of class INSPEcT or INSPEcT_model}

\item{modelSelection}{'aic' compares nested models closest to the one with lowest AIC, 'llr' compares all nested models, 
'hib' is a mix between the previous two. (default 'aic')}

\item{preferPValue}{a logical, if TRUE (default) limit the search for best models among the ones with succeded the goodness of fit test.}

\item{padj}{a logical, if TRUE (default) correct the p-values for multiple testing}

\item{p_goodness_of_fit}{a numeric, the threshold for the goodness-of-fit test (default = .1)}

\item{p_variability}{a numeric, a vector with the thresholds for the p-value of the variability test (one threshold for each rate, default = rep(.05, 3))}

\item{limitModelComplexity}{a logical that limits the complexity of the function used to describe dynamics to the length of the time-course (default = FALSE)}
}
\value{
A matrix containing p-values calculated for each rate
}
\description{
This method is used to calculate all the p-values relative to the variability of synthesis, processing and degradation rates.
For object modeled with nascent RNA or when non-functional modeling was used, the variability is calculated using the 
confidence intervals. For objects modeled without nascent RNA, model selection is performed by comparing the likelihood of 
different (nested) models.
}
\details{
ratePvals retrieve a single p-value for each rate and gene associated to its variability (null hypothesis = the rate is not
changing between the conditions)
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
# Set the chi-squared threshold at .2 for nascentInspObj10 object
nascentInspObj10 <- calculateRatePvals(nascentInspObj10, p_goodness_of_fit=.2)
}
\seealso{
\code{\link{makeSimModel}}, \code{\link{makeSimDataset}}
}
