% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_de_analyses.R
\name{get_deg_counts}
\alias{get_deg_counts}
\title{Get a count table of differentially expressed genes per contrast}
\usage{
get_deg_counts(deg_list)
}
\arguments{
\item{deg_list}{A list of data frames with gene-wise test statistics for
differentially expressed genes as returned by \code{get_deg_list()}.}
}
\value{
A data frame with the following variables:
\describe{
\item{contrast}{Character, contrast name.}
\item{up}{Numeric, number of up-regulated genes.}
\item{down}{Numeric, number of down-regulated genes.}
\item{total}{Numeric, total number of differentially expressed genes.}
\item{perc_up}{Numeric, percentage of up-regulated genes.}
\item{perc_down}{Numeric, percentage of down-regulated genes.}
\item{perc_total}{Numeric, percentage of diffferentially expressed genes.}
}
}
\description{
Get a count table of differentially expressed genes per contrast
}
\examples{
data(deg_list)
deg_counts <- get_deg_counts(deg_list)
}
