% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_data_processing.R
\name{add_size_factors}
\alias{add_size_factors}
\title{Add size factors to normalize count data by library size or by biomass}
\usage{
add_size_factors(se, spikein = FALSE, spikein_pattern = "ERCC")
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object with a count matrix and sample
metadata.}

\item{spikein}{Logical indicating whether or not to normalize data
using spike-ins. If FALSE, data will be normalized by library size.
Default: FALSE.}

\item{spikein_pattern}{Character with the pattern (regex) to use
to identify spike-in features in the count matrix. Only valid
if \code{spikein_norm = TRUE}.}
}
\value{
A \code{SummarizedExperiment} object as in \strong{se}, but with an extra
column in the colData slot named "sizeFactor". This column contains size
factors that will be used by DESeq2 when performing differential expression
analyses.
}
\description{
Add size factors to normalize count data by library size or by biomass
}
\examples{
data(se_chlamy)
se_norm <- add_size_factors(se_chlamy)
}
