% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getResult.R
\name{getResult}
\alias{getResult}
\title{Get data on samples from HoloFood database}
\usage{
getResult(accession, ...)
}
\arguments{
\item{accession}{\code{Character vector} specifying the
accession IDs of type samples.}

\item{...}{optional arguments:
\itemize{
  
  \item \strong{use.cache} \code{Logical scalar} specifying whether to
  use cache. Note that when \code{get.metabolomic = TRUE} is specified, the
  file from the MetaboLights is stored in the local system to the location
  specified by \code{cache.dir} despite of the value of \code{use.cache}.
  (Default: \code{FALSE})
  
  \item \strong{cache.dir} \code{Character scalar} specifying cache
  directory. (Default: \code{tempdir()})
  
  \item \strong{clear.cache} \code{Logical scalar} specifying whether to
  use.cache (Default: \code{FALSE})
  
  \item \strong{assay.type} \code{Character scalar} specifying the name of
  assay in resulting \code{TreeSummarizedExperiment} object.
  (Default: \code{"counts"}) 
  
  \item \strong{get.metabolomic} \code{Logical scalar} specifying whether to
  retrieve processed metabolomic data from MetaboLights database. For
  retrieving spectra data, refer to
  \code{\link[HoloFoodR:getMetaboLights]{getMetaboLights}} documentation.
  (Default: \code{FALSE})
  
}}
}
\value{
\code{MultiAssayExperiment}
}
\description{
Get data on samples from HoloFood database
}
\details{
With \code{getResult}, you can fetch data on samples from the HoloFood
database. Compared to \code{getData}, this function is more convenient for
fetching the samples data because it converts the data to
\code{MultiAssayExperiment} where different omics are stored as
\code{TreeSummarizedExperiment} objects which are optimized for downstream
analytics. Columns of returned \code{MultiAssayExperiment} are individual
animals. These columns are linked with individual samples that are stored in
\code{TreeSummarizedExperiment} objects.

The HoloFood database lacks non-targeted metabolomic data but they can be
fetched from MetaboLights resource. Certain datasets include processed
features. Those datasets can be retrieved with the function
\code{getResult} which integrates metabolomic data with other datasets from
HoloFood.

Furthermore, while the HoloFoodR database does not include metagenomic
assembly data, users can access such data from the MGnify database. The
MGnifyR package provides a convenient interface for accessing this database.
By employing \code{MGnifyR::getResult()}, users can obtain data formatted as
a \code{MultiAssayExperiment} object, containing multiple
\code{TreeSummarizedExperiment} objects. Consequently, data from both
HoloFood and MGnify databases are inherently compatible for subsequent
downstream analysis.
}
\examples{

# Find samples on certain animal
samples <- doQuery("samples", animal_accession = "SAMEA112904746")

# Get the data
mae <- getResult(samples[["accession"]])
mae

}
\seealso{
\code{\link[HoloFoodR:getData]{getData}}
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
\code{\link[MGnifyR:getResult]{MGnifyR:getResult}}
}
