% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCnorm.R
\name{VCnorm}
\alias{VCnorm}
\title{Compute Vanilla Count Correction.}
\usage{
VCnorm(hic = NULL, qtlTh = 0.15, vcsqrt = TRUE)
}
\arguments{
\item{hic}{\if{html}{\out{<contactMatrix>}}: The HiC maps chunk to normalize.}

\item{qtlTh}{\if{html}{\out{<numerical>}}: The threshold quantile below which
the bins will be ignored. (Default 0.15)}

\item{vcsqrt}{\if{html}{\out{<logical>}}: Whether the square root should be
applied. (Default TRUE)}
}
\value{
A matrices list.
}
\description{
Compute Vanilla Count or Vanilla Count square root correction
normalization on hic maps.
}
\details{
VCnorm
}
\examples{
# Data
data(HiC_Ctrl.cmx_lst)

HiC_Ctrl_VC.cmx <- VCnorm(HiC_Ctrl.cmx_lst[["2L_2L"]])
HiC_Ctrl_VC_SQRT.cmx <- VCnorm(HiC_Ctrl.cmx_lst[["2L_2L"]], vcsqrt = TRUE)

}
