% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchPairs.R
\name{SearchPairs}
\alias{SearchPairs}
\title{Creates pairs from genomic index.}
\usage{
SearchPairs(
  indexAnchor = NULL,
  indexBait = NULL,
  minDist = NULL,
  maxDist = NULL,
  exclude_duplicates = TRUE,
  exclude_self_interactions = TRUE,
  verbose = FALSE,
  cores = 1
)
}
\arguments{
\item{indexAnchor}{\if{html}{\out{<GRanges>}}: A first indexed GRanges object
used as pairs anchor (must be indexed using IndexFeatures()).}

\item{indexBait}{\if{html}{\out{<GRanges>}}: A second indexed GRanges object
used as pairs bait (must be indexed using IndexFeatures()).
If NULL, indexAnchor is used instead (Default NULL)}

\item{minDist}{\if{html}{\out{<numeric>}}: Minimal distance between anchors
and baits. (Default NULL)}

\item{maxDist}{\if{html}{\out{<numeric>}}: Maximal distance between anchors
and baits. (Default NULL)}

\item{exclude_duplicates}{\if{html}{\out{<logical>}} Should duplicated
pairs ("2L:100_2L:150" & "2L:150_2L:100") be removed?
(Default: TRUE)}

\item{exclude_self_interactions}{\if{html}{\out{<logical>}} Should pairs
between the same bin ("2L:100_2L:100") be excluded? (Default: TRUE)}

\item{verbose}{\if{html}{\out{<logical>}}: Show the progression in console?
(Default FALSE)}

\item{cores}{\if{html}{\out{<integer>}} : Number of cores to use. (Default 1)}
}
\value{
A GInteractions object.
}
\description{
Creates pairs of coordinates from indexed anchor and bait
genomic coordinates according to distance constraints.
}
\details{
SearchPairs
}
\examples{
# Data
data(Beaf32_Peaks.gnr)

# Index Beaf32
Beaf32_Index.gnr <- IndexFeatures(
    gRangeList = list(Beaf = Beaf32_Peaks.gnr),
    chromSizes = data.frame(seqnames = c("2L", "2R"),
        seqlengths = c(23513712, 25286936)),
    binSize = 100000
)

# Beaf32 <-> Beaf32 Pairing
Beaf_Beaf.gni <- SearchPairs(indexAnchor = Beaf32_Index.gnr)

}
