% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeDistanceEffect.R
\name{normalizeDistanceEffect}
\alias{normalizeDistanceEffect}
\title{Normalize distance effect.}
\usage{
normalizeDistanceEffect(object, loessSampleSize = NULL, parallel = FALSE)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{loessSampleSize}{The number of positions used as a sample to estimate the effect of distance
on proportion of interactions. Defaults to
\code{object$loessSampleSize} which is originally set to
\code{defaultHiCDOCParameters$loessSampleSize} = 20000.}

\item{parallel}{Should the normalization be run in parallel mode? Default to FALSE.}
}
\value{
A \code{\link{HiCDOCDataSet}} with normalized interactions.
}
\description{
Normalizes interactions by their "expected" value relative to the distance
that separates their positions. The "expected" values are estimated with a
loess regression on the proportion of interactions for each distance.
}
\examples{
data(exampleHiCDOCDataSet)
object <- normalizeDistanceEffect(exampleHiCDOCDataSet)

}
\seealso{
\code{\link{normalizeTechnicalBiases}},
\code{\link{normalizeBiologicalBiases}},
\code{\link{HiCDOC}}
}
