% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_hicpro_allvalidpairs_counts.R
\name{add_hicpro_allvalidpairs_counts}
\alias{add_hicpro_allvalidpairs_counts}
\title{add_hicpro_allvalidpairs_counts}
\usage{
add_hicpro_allvalidpairs_counts(
  gi_list,
  allvalidpairs_path,
  chrs = NULL,
  binned = TRUE,
  add_inter = FALSE
)
}
\arguments{
\item{gi_list}{valid gi_list instance. 
See \code{?gi_list_validate} for details. You can also detect whether
a gi_list instance is uniformly binned, along with its bin size
using \code{gi_list_binsize_detect}.}

\item{allvalidpairs_path}{allValidPairsfile obtained from HiC-Pro (e.g.,
'GSM2572593_con_rep1.allvalidPairs.txt')}

\item{chrs}{a subset of chromosomes' e.g., c('chr21','chr22'). Defaults
to all chromosomes in the \code{gi_list} instance.}

\item{binned}{TRUE if the gi_list instance is uniformly binned 
(helps faster execution). Defaults to TRUE.}

\item{add_inter}{Interchromosomal interaction counts added as a 1D feature
named 'inter' on regions metadata handle of each gi_list element (e.g., 
\code{gi_list[[1]]@regions@elementMetadata} or not;
default FALSE}
}
\value{
\code{gi_list} instance with counts on the metadata (e.g., 
\code{mcols(gi_list[[1]])} handle on each list element, and 'inter' on 
regions metadata handle of each element if \code{add_inter=TRUE}.
}
\description{
This function converts HiC-Pro outputs in allValidPairs format into a
gi_list instance.
}
