% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_2D_features.R
\name{add_2D_features}
\alias{add_2D_features}
\title{add_2D_features}
\usage{
add_2D_features(gi, df, features = NULL, agg = sum)
}
\arguments{
\item{gi}{Element of a valid \code{gi_list} instance
(restricted to a single chromosome e.g., \code{gi_list[['chr9']]}---see
\code{?gi_list_validate} for a detailed explanation of valid \code{gi_list}
instances).}

\item{df}{data frame for a single chromosome containing columns named chr,
startI and startJ and features to be added with their respective names 
(if df contains multiple chromosomes, you can convert it into a
list of smaller data.frames for each chromosome and apply this function
with \code{sapply}).}

\item{features}{features to be added. Needs to be subset of 
\code{colnames(df)}. Defaults to all columns in \code{df} other than
'chr','start',and 'end'.}

\item{agg}{any vector valued function with one data argument:
defaults to \code{mean}.}
}
\value{
a gi_list element with 2D features stored in metadata handle
(i.e., \code{mcols(gi)}).
}
\description{
Adds 2D features to a gi_list instance. If any bin on gi_list overlaps with
multiple feature records, features are aggregated among matches according
to the univariate vector valued function agg (e.g., sum, mean). For efficient
use of memory, using add/expand 1D features (see \code{?add_1D_features} and
\code{expand_1D_features}) in sequence is recommended
instead of using \code{add_2D_features} directly for each chromosome.
}
\examples{
df<-data.frame(chr='chr9',start=seq(1e6,10e6,1e6))
gi_list<-generate_df_gi_list(df,Dthreshold=500e3)
feats<-data.frame(chr='chr9',
startI=seq(1e6,10e6,1e6),startJ=seq(1e6,10e6,1e6),counts=rpois(10,lambda=5))
gi_list[['chr9']]<-add_2D_features(gi_list[['chr9']],feats)
}
