% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_make_ranges}
\alias{Brick_make_ranges}
\title{Creates a ranges object from provided vectors.}
\usage{
Brick_make_ranges(chrom, start, end, strand = NA, names = NA)
}
\arguments{
\item{chrom}{\strong{Required}.
A 1 dimensional character vector of size N specifying the chromosomes in the
ranges.}

\item{start}{\strong{Required}.
A 1 dimensional numeric vector of size N specifying the start positions in
the ranges.}

\item{end}{\strong{Required}.
A 1 dimensional numeric vector of size N specifying the end positions in
the ranges. Must be less than Start.}

\item{strand}{\strong{Optional}.
A 1 dimensional character vector of size N specifying the strand of the
ranges. If not provided, this will be set to the default *.}

\item{names}{\strong{Optional}.
A 1 dimensional character vector of size N specifying the names of the
ranges. If not provided, this will be set to the default chr:start:end.}
}
\value{
A GenomicRanges object with the previous sort order being preserved
}
\description{
\code{Brick_make_ranges} creates a GRanges object from the provided arguments
}
\examples{

Chrom <- c("chrS","chrS","chrS","chrS","chrS")
Start <- c(10000,20000,40000,50000,60000)
End <- c(10001,20001,40001,50001,60001)
Test_ranges <- Brick_make_ranges(chrom = Chrom, start = Start, end = End)

}
