% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_get_chrominfo}
\alias{Brick_get_chrominfo}
\title{Get the chrominfo for the Hi-C experiment.}
\usage{
Brick_get_chrominfo(Brick, resolution = NA)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}
}
\value{
A three column data.frame containing chromosomes, nrows and length.

chromosomes corresponds to all chromosomes in the provided bintable.

nrows corresponds to the number of entries in the bintable or dimension
for that chromosome in a Hi-C matrix.

Length is the total bp length of the same
chromosome (max value for that chromosome in the bintable).
}
\description{
\code{Brick_get_chrominfo} fetches the associated chrominfo table for the
Brick it is associated to.
}
\examples{

Bintable_path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "HiCBricks_chrominfo_test")

dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable_path, 
bin_delim=" ", remove_existing=TRUE, output_directory = out_dir, 
file_prefix = "HiCBricks_vignette_test", resolution = 100000,
experiment_name = "HiCBricks vignette test")

Brick_get_chrominfo(Brick = My_BrickContainer, resolution = 100000)

}
