% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_add_ranges}
\alias{Brick_add_ranges}
\title{Store a ranges object in the Brick store.}
\usage{
Brick_add_ranges(
    Brick,
    ranges,
    rangekey,
    resolution = NA,
    all_resolutions = FALSE,
    num_cpus = 1
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{ranges}{\strong{Required}.
An object of class ranges specifying the ranges to store in the Brick.}

\item{rangekey}{\strong{Required}.
The name to use for the ranges within the Brick store.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{all_resolutions}{\strong{Optional}. Default FALSE
If resolution is not defined and all_resolutions is TRUE, the resolution
parameter will be ignored and the function is executed on all files listed
in the Brick container}

\item{num_cpus}{\strong{Optional}. Default 1
When an object of class BrickContainer is provided, num_cpus defines the
maximum number of parallel jobs that will be run.}
}
\value{
Returns TRUE if completed successfully.
}
\description{
\code{Brick_add_ranges} loads a GRanges object into the Brick store.
}
\details{
With this function it is possible to associate other ranges objects with the
Brick store. If metadata columns are present, the are also loaded into the
Brick store. Although not explicitly asked for, the metadata columns should
not be of type list as this may create complications down the line. We
ask for ranges objects, so if the same ranges object is later retrieved
two additional columns will be present. These are the strand and width
columns that are obtained when a ranges is converted into a data.frame.
Users can ignore these columns.
}
\examples{

Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "add_ranges_test")

dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Chrom <- c("chrS","chrS","chrS","chrS","chrS")
Start <- c(10000,20000,40000,50000,60000)
End <- c(10001,20001,40001,50001,60001)
Test_ranges <- Brick_make_ranges(chrom = Chrom, start = Start, end = End)
Brick_add_ranges(Brick = My_BrickContainer, ranges = Test_ranges,
rangekey = "test_ranges", all_resolutions = TRUE)

}
