% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrickContainer_functions.R
\name{BrickContainer_list_files}
\alias{BrickContainer_list_files}
\title{Get the list of HDF files present in the Brick container.}
\usage{
BrickContainer_list_files(
    Brick = NULL,
    chr1 = NA,
    chr2 = NA,
    type = NA,
    resolution = NA
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created
with Create_many_Bricks.}

\item{chr1}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the rows of the matrix}

\item{chr2}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the columns of the matrix}

\item{type}{A value from one of cis, trans specifying the type of files to list
cis will list intra-choromosomal file paths and trans will list
inter-chromosomal file paths.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}
}
\value{
A 5 column tibble containing chromosome pairs, Hi-C resolution,
the type of Hi-C matrix and the path to a particular Hi-C matrix file.
}
\description{
\code{BrickContainer_list_files} fetches the list of HDF files associated to a
particular BrickContainer
}
\examples{
Bintable.path <- system.file("extdata",
"Bintable_100kb.bins", package = "HiCBricks")
out_dir <- file.path(tempdir(), "BrickContainer_list_file_test")
dir.create(out_dir)
My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
   bin_delim = " ", output_directory = out_dir, file_prefix = "Test", 
   experiment_name = "Vignette Test", resolution = 100000, 
   remove_existing = TRUE)

BrickContainer_list_files(Brick = My_BrickContainer, chr1 = "chr2L",
chr2 = NA)

}
