% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrickContainer_functions.R
\name{BrickContainer_list_chromosomes}
\alias{BrickContainer_list_chromosomes}
\title{Return the descriptive name of the BrickContainer}
\usage{
BrickContainer_list_chromosomes(Brick = NULL, lengths = FALSE)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created
with Create_many_Bricks.}

\item{lengths}{Default FALSE
If TRUE, will also return the chromosomal lengths}
}
\value{
If lengths is FALSE, only the chromosome names are returned. If
lengths is TRUE, a data.frame containing the chromosome names and their
lengths is provided.
}
\description{
\code{BrickContainer_list_chromosomes} returns the chromosomes available in
the BrickContainer
}
\examples{
Bintable.path <- system.file("extdata",
"Bintable_100kb.bins", package = "HiCBricks")

out_dir <- file.path(tempdir(), "BrickContainer_list_chromosome_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test", 
    experiment_name = "Vignette Test", resolution = 100000, 
    remove_existing = TRUE)

BrickContainer_list_chromosomes(My_BrickContainer)
}
