% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prcompPlot.R
\name{prcompPlot}
\alias{prcompPlot}
\title{PCA plot}
\usage{
prcompPlot(
  object,
  pc_x = 1,
  pc_y = 2,
  scale = FALSE,
  colFactor = NULL,
  pchFactor = NULL,
  palette = "rainbow",
  legend = TRUE,
  ...
)
}
\arguments{
\item{object}{data.frame, matrix or \code{prcomp} object.}

\item{pc_x}{integer, principle component for the plot x dimension.}

\item{pc_y}{integer, principle component for the plot y dimension.}

\item{scale}{logical, whether to scale to unit variance before PCA.}

\item{colFactor}{factor or vector, colour the points by this factor,
default is \code{NULL}.}

\item{pchFactor}{factor or vector, point-type by this factor,
default is \code{NULL}.}

\item{palette}{string, the function to call to create a vector of
contiguous colours with \code{levels(colFactor)} steps.}

\item{legend}{logical, whether to display a legend on the plot.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
None
}
\description{
Generates a Principle Component plot for data.frames, matrices,
or a pre-made \code{\link{prcomp}} object.
}
\details{
A data.frame object will be coerced internally to a matrix.
Matrices must be of type \code{double} or \code{integer}. The
\code{prcompPlot} function will then perform a principle component analysis
on the data prior to plotting. The function is call
is \code{prcomp(t(object), retx=TRUE, center=TRUE, scale.=scale)}.
Instead of specifying a data.frame or matrix, a pre-made \code{prcomp} object
can be given to \code{prcompPlot}. In this case, care should be taken in
setting the appropriate value of \code{scale.}. If a vector is given to
\code{colFactor} or \code{pchFactor}, they will be coerced internally to
factors.

For the default \code{NULL} values of \code{colFactor} and \code{pchFactor},
all colours will be black and circles the point type, respectively.
}
\examples{
library(HarmanData)
data(IMR90)
expt <- imr90.info$Treatment
batch <- imr90.info$Batch
prcompPlot(imr90.data, colFactor=expt)
pca <- prcomp(t(imr90.data), scale.=TRUE)
prcompPlot(pca, 1, 3, colFactor=batch, pchFactor=expt, palette='topo.colors',
main='IMR90 PCA plot of Dim 1 and 3')
}
\seealso{
\code{\link{prcomp}} \code{\link{rainbow}}
}
