% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{hpaSubset}
\alias{hpaSubset}
\alias{hpaListParam}
\title{Subset downloaded data}
\usage{
hpaSubset(
  data = NULL,
  targetGene = NULL,
  targetTissue = NULL,
  targetCellType = NULL,
  targetCancer = NULL,
  targetCellLine = NULL
)

hpaListParam(data = NULL)
}
\arguments{
\item{data}{Input the list object generated by \code{hpaDownload()} or
\code{hpaSubset()}}

\item{targetGene}{Vector of strings of HGNC gene symbols. It will be used to
subset every dataset in the list object. You can also mix HGNC gene symbols
and ensemnbl ids (start with ENSG) and they will be converted to HGNC gene
symbols.}

\item{targetTissue}{Vector of strings of normal tissues. Will be used to
subset the \code{normal_tissue} and \code{rna_tissue} dataset.}

\item{targetCellType}{Vector of strings of normal cell types. Will be used to
subset the \code{normal_tissue} dataset.}

\item{targetCancer}{Vector of strings of cancer types. Will be used to subset
the \code{pathology} dataset.}

\item{targetCellLine}{Vector of strings of cell lines. Will be used to subset
the \code{rna_cell_line} dataset.}
}
\value{
\code{hpaSubset} will return a list of tibbles as the result of
  subsetting, depending on the input data.

The output of \code{hpaListParam()} is a list of vectors containing
  all subset parameter for the downloaded data.
}
\description{
\code{hpaSubset()} subsets data by gene name, tissue, cell type, cancer
and/or cell line. The input is the list object generated by
\code{hpaDownload()} or as the output of another \code{hpaSubset()}. Use
\code{hpaListParam()} to see the list of available parameters for a specific
list object. This is a convenient wrapper for `lapply/filter` and works on
any table which contain 'gene', 'tissue', 'cell_type', 'cancer', and
'cell_line' columns.

\code{hpaListParam()} list available variables in downloaded data that can be
used as parameters to subset the data via \code{hpaSubset()}. This function
work with the data object generated by \code{hpaDownload()} or a previous
call of \code{hpaSubset()}. This is a convenient wrapper for `lapply/unique`
and works on any table which contain 'tissue', 'cell_type', 'cancer', and
'cell_line' columns.
}
\examples{
  downloadedData <- hpaDownload(downloadList='histology', version='example')
  geneList <- c('TP53', 'EGFR')
  tissueList <- c('breast', 'cerebellum', 'skin 1')
  cancerList <- c('breast cancer', 'glioma', 'melanoma')

  subsetData <- hpaSubset(data=downloadedData,
                          targetGene=geneList,
                          targetTissue=tissueList,
                          targetCancer=cancerList)

  downloadedData <- hpaDownload(downloadList='histology', version='example')
  params <- hpaListParam(data=downloadedData)
  params$normal_tissue

}
\seealso{
Other downloadable datasets functions: 
\code{\link{hpaDownload}()},
\code{\link{hpaExport}()}
}
\concept{downloadable datasets functions}
