% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hippo.R
\name{hippo_diffexp}
\alias{hippo_diffexp}
\title{HIPPO's differential expression}
\usage{
hippo_diffexp(
  sce,
  top.n = 5,
  switch_to_hgnc = FALSE,
  ref = NA,
  k = NA,
  plottitle = ""
)
}
\arguments{
\item{sce}{SingleCellExperiment object with hippo}

\item{top.n}{number of markers to return}

\item{switch_to_hgnc}{if the current gene names are ensemble ids, and would
like to switch to hgnc}

\item{ref}{a data frame with columns 'hgnc' and 'ensg' to match each other,
only required when switch_to_hgnc is set to TRUE}

\item{k}{number of rounds of clustering that you'd like to see result.
Default is 1 to K}

\item{plottitle}{title of the resulting plot}
}
\value{
list of differential expression result
}
\description{
HIPPO's differential expression
}
\examples{
data(toydata)
set.seed(20200321)
toydata = hippo(toydata,K = 10,z_threshold = 1,outlier_proportion = 0.01)
result = hippo_diffexp(toydata)
}
