% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel.R
\name{makeEpitopeCalls}
\alias{makeEpitopeCalls}
\title{Make Epitope Calls}
\usage{
makeEpitopeCalls(epi_ds, padj_cutoff = 0.05, one_hit_filter = TRUE)
}
\arguments{
\item{epi_ds}{HERONEpitopeDataSet with pvalue assay}

\item{padj_cutoff}{p-value cutoff to use}

\item{one_hit_filter}{filter one hit epitopes?}
}
\value{
HERONEpitopeDataSet with calls assay added
}
\description{
Make Epitope Calls
}
\examples{
data(heffron2021_wuhan)
seq_pval_res <- calcCombPValues(heffron2021_wuhan)
pr_pval_res <- convertSequenceDSToProbeDS(seq_pval_res)
pr_calls_res <- makeProbeCalls(pr_pval_res)
epi_segments_uniq_res <- findEpitopeSegments(
    PDS_obj = pr_calls_res,
    segment_method = "unique"
)
epi_padj_uniq <- calcEpitopePValues(
    probe_pds = pr_calls_res,
    epitope_ids = epi_segments_uniq_res,
    metap_method = "wilkinsons_max1"
)
makeEpitopeCalls(epi_padj_uniq)
}
