% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimmaMA.R
\name{glimmaMA}
\alias{glimmaMA}
\alias{glimmaMD}
\title{Glimma MA Plot}
\usage{
glimmaMA(x, ...)

glimmaMD(x, ...)
}
\arguments{
\item{x}{the DE object to plot.}

\item{...}{additional arguments affecting the plots produced. See specific methods for detailed arguments.}
}
\value{
htmlwidget object or \code{NULL} if \code{html} argument is specified.
}
\description{
Generic function for drawing a two-panel interactive MA plot, a special case of the
glimmaXY plot.
The function invokes the following methods which depend on the class of the first argument:
\itemize{
  \item \code{\link{glimmaMA.MArrayLM}} for limma analysis
  \item \code{\link{glimmaMA.DGEExact}} for edgeR analysis, produced from \code{\link{exactTest}}
  \item \code{\link{glimmaMA.DGELRT}} for edgeR analysis, produced from \code{\link{glmLRT}}
  \item \code{\link{glimmaMA.DESeqDataSet}} for DESeq2 analysis }
glimmaMD is an alias for glimmaMA.
}
\details{
The summary plot on the left represents gene-wise log-fold-change (logFC) on the y-axis versus average gene
    expression calculated as log-counts-per-million (logCPM) values.
    We call our summary plot an MA plot because this type of plot was originally referred to as an MA plot in
    the \code{limma} package, with the M-value representing logFC and A-value representing average expression -
    it has since been renamed to MD plot in the \code{limma} package.
    The expression plot on the right displays sample expression values for a single gene.
    Interactions with the htmlwidget include clicking on genes (points) in the summary plot to bring up
    associated sample expression values in the expression plot, as well as the summary statistics in the table below.
    Alternatively, users can interact with the table by clicking on genes (rows) to highlight genes in the summary plot,
    as well as bring up associated sample expression values in the expression plot.
    Briefly, other interactive features include a search box for the table, buttons to save plots and data
    (summary statistics and expression values), additional pop-up information when hovering on points in plots,
    and rescaling of the y-axis in the expression plot.
}
\examples{
methods(glimmaMA) # show methods for glimmaMA

}
\author{
Hasaru Kariyawasam, Shian Su and Oliver Voogd
}
