% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxPlotWin.R
\name{gtoxPlotWin}
\alias{gtoxPlotWin}
\title{Create winning curve plots}
\usage{
gtoxPlotWin(chid, aeid, bline = "bmad", collapse = TRUE)
}
\arguments{
\item{chid}{Integer of length 1, the chid value}

\item{aeid}{Integer, the aeid values to plot}

\item{bline}{Character of length 1, the value used for drawing the baseline
noise}

\item{collapse}{Logical, collapse the data by spid when true}
}
\value{
None
}
\description{
\code{gtoxPlotWin} creates best fit plot.
}
\details{
When 'collapse' is TRUE the plotted points will be the mean of the values
based on spid.

Any values for 'bline' other than 'coff' will use 3*bmad.
}
\examples{

\dontrun{
## Load chemical ID
chid <- gtoxLoadChem(field="chnm", val="acrylamide", include.spid=FALSE)$chid

## Load Assay endpoint ID
aeid <- gtoxLoadAeid(fld=c("asid","aenm"), 
          val=list(1L, "GSH content_GSH content_4h_dn"), add.fld="asid")$aeid

## Plot winning model
gtoxPlotWin(chid = chid, aeid = aeid, bline="bmad", collapse=TRUE)
}

}
