% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxLoadChem.R
\name{gtoxLoadChem}
\alias{gtoxLoadChem}
\title{Load sample/chemical information}
\usage{
gtoxLoadChem(field = NULL, val = NULL, exact = TRUE,
  include.spid = TRUE)
}
\arguments{
\item{field}{Character of length 1, the field to query on}

\item{val}{Vector of values to subset on}

\item{exact}{Logical, should chemical names be considered exact?}

\item{include.spid}{Logical, should spid be included?}
}
\value{
A data.table with the chemical information for the given parameters
}
\description{
\code{gtoxLoadChem} queries the gtox database and returns the chemcial
information for the given field and values.
}
\details{
The 'field' parameter is named differently from the 'fld' parameter seen
in other functions because it only takes one input.

The functionality of the 'exact' parameter cannot be demonstrated within
the SQLite environment. However, in the MariaDB environment the user should
be able to give parital chemcial name strings, to find chemicals with
similar names. For example, setting 'val' to "phenol" when 'field' is "chnm"
and 'exact' is \code{FALSE} might pull up the chemicals "mercury". More
technically, setting 'exact' to \code{FALSE} passes the string in 'val' to
an RLIKE statement within the MariaDB query.
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Passing no parameters gives all of the registered chemicals with their
## sample IDs
gtoxLoadChem()

## Or the user can exclude spid and get a unique list of chemicals
gtoxLoadChem(include.spid = FALSE)

## Other examples:
gtoxLoadChem(field = "chnm", val = "chromium")

## Reset configuration
options(conf_store)

}
